


memory = 
{

-------------------------------------------------
init = function(id)
calls.enter("memory.init",id)

	Humans[id].memory = {}
	--	sounds
	Humans[id].memory.clear_sounds = {}
	Humans[id].memory.known_enemies = {}
	
	log(id, "========================================================")
	log(id, "==============  ID===============")
	log(id, "========================================================")

	Humans[id].freeze = 0
--	Humans[id].turn = 0
	Humans[id].roaming = nil
	Humans[id].orders = 0
	Humans[id].lastBusyTime = 0
	memory.clearLastSeen(id)

	log(id, "==>   human.assigned_target = NONE")
	Humans[id].assigned_target = NONE
	
	log(id, "==>   human.hates_person = {}")
	Humans[id].hates_person = {}
		
	log(id, "==>   human.hates_force = {}")
	Humans[id].hates_force = {}
		
	log(id, "==>   human.status = GREEN")
	Humans[id].status = "GREEN"

	log(id, "==>   human.app = NONE")
	Humans[id].app = NONE

	log(id, "==>   human.post = NONE")
	Humans[id].post = NONE
	
	log(id, "==>   human.point_try = 1")
	Humans[id].point_try = 1
	
	log(id, "==>   human.moveonly = false")
	Humans[id].moveonly = false 
	
	log(id, "==>   human.alert = false")
	Humans[id].alert = false 
	
	log(id, "==>   human.surrounded = false")
	Humans[id].surrounded = false 
	
	log(id, "==>   human.underfire = 0")
	Humans[id].underfire = 0
	
	log(id, "==>   human.strategy = 0")
	Humans[id].strategy = 0
	
	log(id, "==>   human.busy = 0")
	Humans[id].busy = 0
	
	log(id, "==>   human.attacked = false")
	Humans[id].attacked = false
	
	log(id, "==>   human.check = NONE")
	Humans[id].check = NONE
	
	log(id, "==>   human.hurt = NONE")
	Humans[id].hurt = NONE
	
	log(id, "==>   human.special = false")
	Humans[id].special = false
	
	log(id, "==>   human.going_target = NONE")
	Humans[id].going_target = NONE
	
	log(id, "==>   human.reportedby = NONE")
	Humans[id].reportedby = NONE
	
	log(id, "==>   human.known = NONE")
	Humans[id].known = NONE
	
	log(id, "==>   human.priority = 0")
	Humans[id].priority = 0
	
	log(id, "==>   human.dangerous = false")
	Humans[id].dangerous = false
	
	log(id, "==>   human.going_behind = false")
	Humans[id].going_behind = false
	
	log(id, "==>   human.going_dir = NONE")
	Humans[id].going_dir = NONE
	
	log(id, "==>   human.current_target = NONE")
	Humans[id].current_target = NONE
	
	log(id, "==>   human.target_health = -1")
	Humans[id].target_health = -1
	
	log(id, "==>   human.try = 0")
	Humans[id].try = 0
	
	log(id, "==>   human.squad = NONE")
	Humans[id].squad = NONE
	
	log(id, "==>   human.leader = NONE")
	Humans[id].leader = NONE

	log(id, "==>   human.initial_squad_size = -1")
	Humans[id].initial_squad_size = -1
	
	log(id, "==>   human.turn_done = false")
	Humans[id].leaderTurnsForSkip = 0
	Humans[id].surroundTurnsForSkip = 0
	
	log(id, "==>   human.retreat = false")
	Humans[id].retreat = false
	
	log(id, "==>   human.shift = 1")
	Humans[id].shift = 1
	
	log(id, "==>   human.patrol_routine = NONE")
	Humans[id].patrol_routine = NONE
	
	log(id, "==>   human.patrol_status = 1")
	Humans[id].patrol_status = 1
	
	log(id, "==>   human.wait_start = -1")
	Humans[id].wait_start = -1
	
	log(id, "==>   human.wait_elapsed = 0")
	Humans[id].wait_elapsed = 0
	
	log(id, "==>   human.waited = false")
	Humans[id].waited = false
	
	log(id, "==>   human.guard_status = 1")
	Humans[id].guard_status = 1
	
	log(id, "==>   human.post = NONE")
	Humans[id].post = NONE
	
	log(id, "==>   human.blasted = false")
	Humans[id].blasted = false
	
	log(id, "==>   human.last_remark = NONE")
	Humans[id].last_remark = NONE
	
	log(id, "==>   human.last_strafe = NONE")
	Humans[id].last_strafe = NONE

	Humans[id].looted = NONE
	
	log(id, "==>   human.visible_enemies = {}")
	Humans[id].visible_enemies = {}
	
	log(id, "==>   human.visible_enemies.size = 0")
	Humans[id].visible_enemies.size = 0
	
	log(id, "==>   human.attack_type = SHOOTING")
	Humans[id].attack_type = "SHOOTING"
	
	log(id, "==>   human.blasted_target = NONE")
	Humans[id].blasted_target = NONE
	
	log(id, "==>   human.blasted_target = nil")
	Humans[id].guard_idle_time = nil
	
	log(id, "==>   human.guard_orientation = nil")
	Humans[id].guard_orientation = nil
	
	Humans[id].initialized = true
	
	log(id, "========================================================")
	log(id, "================ =================")
	log(id, "========================================================")

calls.leave("memory.init",id)
end, 

-------------------------------------------------
--      
addKnownEnemy = function(id, add_id, tm)
calls.enter("memory.addKnownEnemy",id,add_id)
	local ret = false
	if(add_id~=id) then
		log(id,"addKnownEnemy ",add_id,tm)
		sounds.removeSoundsFrom(id,add_id)

		local finded = false
		local find = function(index, value)
			if(value.id==add_id) then 
				finded = true
				value.x, value.y, value.z, value.f 	= getPosition(add_id)
				value.vx, value.vy, value.vz, value.vf 	= getPersonOrientation(add_id) 
			end
		end
		table.foreach(Humans[id].memory.known_enemies,find)
		if(not finded) then 
			local nx, ny, nz, nf 	= getPosition(add_id)
			local ax, ay, az, af 	= getPersonOrientation(add_id)

			local known_enemy = 
			{
				id = add_id,
				x = nx,
				y = ny,
				z = nz, 
				f = nf,
				vx = ax,
				vy = ay,
				vz = az,
				vf = af,
			}
			table.insert(Humans[id].memory.known_enemies,deepcopy(known_enemy))
			ret = true
		end
	end
calls.leave("memory.addKnownEnemy",1)
	return(ret)
end,

touchKnownBySound = function(id,sowner,sx, sy, sz, sf)
calls.enter("memory.touchKnownBySound",id,sowner)
	local ret = false

	local find = function(index, value)
		if(value.id==sowner) then 
			log(id, "Touch known by sound", sowner)
			value.x = sx
			value.y = sy
			value.z = sz 
			value.f = sf
			ret = true 
			return(1)
		end
	end
	table.foreach(Humans[id].memory.known_enemies,find)

calls.leave("memory.touchKnownBySound",ret)
	return(ret)
end,

-------------------------------------------------
--      
removeKnownEnemy = function(id, add_id)
calls.enter("memory.removeKnownEnemy",id)
	local finded=false
	local find = function(index, value)
		if(value.id==add_id) then 
			log(id, " ", add_id, "   ")
			table.remove(Humans[id].memory.known_enemies,index)
			sounds.removeSoundsFrom(id,add_id)
			finded = true 
			return(1)
		end
	end
	table.foreach(Humans[id].memory.known_enemies,find)
	if(Humans[id].assigned_target==add_id) then
		Humans[id].assigned_target = NONE
	end
	if(Humans[id].known==add_id) then
		Humans[id].known = NONE
	end
	if(Humans[id].current_target==add_id) then
		Humans[id].current_target = NONE
	end
	if (Humans[id].going_target == add_id) then
		Humans[id].going_target = NONE
	end
calls.leave("memory.removeKnownEnemy")
	return finded
end,
-------------------------------------------------
--        
removeKnownEnemyForAll = function(id, add_id)
calls.enter("memory.removeKnownEnemyForAll",id)
	local removeall = function(index, human)
		if(relations(team(id), team(human.id)) == "ally") then
			memory.removeKnownEnemy(human.id, add_id)
		end
	end
	table.foreach(Humans,removeall)
	Humans[add_id].reportedby = NONE
calls.leave("memory.removeKnownEnemyForAll",id)
end,

removeKnownEnemyFromTeam = function(ally_clan,id)
calls.enter("memory.removeKnownEnemyForAll",id)
	local removeall = function(index, human)
		if(team(human.id)==ally_clan) then
			memory.removeKnownEnemy(human.id, id)
		end
	end
	table.foreach(Humans,removeall)
	Humans[id].reportedby = NONE
calls.leave("memory.removeKnownEnemyForAll",id)
end,

--------------------------------------------------
--  
cleanKnownEnemies = function(id)
calls.enter("memory.cleanKnownEnemies",id)
	local clean = function(index,value)
		local target = value.id
		if (not(IsAlive(target))) then
			log(id, " ", target, "")
			memory.removeKnownEnemyForAll(id, target)
		end
	end
	table.foreach(Humans[id].memory.known_enemies, clean)
calls.leave("memory.cleanKnownEnemies",id)
end,

--------------------------------------------------
--      
getClosestKnownEnemy = function(id)
calls.enter("memory.getClosestKnownEnemy",id)
	local enemy = nil
	local distance = 10000

	local find_last = function(index,value)
		local dist = service.person2point_distance(id,value.x,value.y,value.z)
		if(dist<distance) then
			enemy = value
			distance = dist
		end
	end

	table.foreach(Humans[id].memory.known_enemies,find_last)
calls.leave("memory.getClosestKnownEnemy",id)
--	enemy = deepcopy(enemy)
	return(enemy)
end,
--------------------------------------------------
getKnownData = function(id, add_id)
calls.enter("memory.getKnownData",id)
	local data = nil

	local find = function(index, value)
		if(value.id==add_id) then 
			data = value
			return 1
		end
	end
	table.foreach(Humans[id].memory.known_enemies,find)
calls.leave("memory.getKnownData")
--	data = deepcopy(data)
	return( data )
end,

addLastSeen = function(id, add_id)
	local finded = false

	local find = function(index, value)
		if(value.id==add_id) then 
			finded = true
			value.turn = fighter_tb.getTurn(id)
			return(1)
		end
	end

	table.foreach(Humans[id].memory.lastSeen,find)
	if(not finded) then 
		local newSeen = 
		{
			id = add_id,
			turn = fighter_tb.getTurn(id)
		}
		table.insert(Humans[id].memory.lastSeen, deepcopy(newSeen))
	end
	Humans[add_id].visibleAtLastTurn = true
end,

resortLastSeen = function(id)
	local forget = function(index, value)
		if(fighter_tb.getTurn(id)-value.turn >= 2) then
			table.remove(Humans[id].memory.lastSeen,index)
		end
	end
	table.foreach(Humans[id].memory.lastSeen, forget)
	Humans[id].visibleAtLastTurn = false
end,

lastSeenPresent = function(id)
	local ret = false

	local check = function(index, value)
		if((not disappeared(value.id)) and healthOK(value.id)) then
log("Visible",value.id," seen at ",value.turn," now ",fighter_tb.getTurn(id))
			ret = true
			return(1)
		end
	end

        table.foreach(Humans[id].memory.lastSeen, check)
        return(ret)
end,

clearLastSeen = function(id)
	Humans[id].memory.lastSeen = {}
	Humans[id].visibleAtLastTurn = false
end,

}